<?php
function check_value($value) {
	if((@count($value)>0 and !@empty($value) and @isset($value)) || $value=='0') {
		return true;
	}
}

function decodeCache($data) {
	return json_decode($data, true);
}

function loadCache($fileName) {
    global $config;

	$file = $config['path_cache'] . $fileName;
	if(!file_exists($file)) return;
	if(!is_readable($file)) return;
	
	$cacheDataRaw = file_get_contents($file);
	if(!check_value($cacheDataRaw)) return;
	
	$cacheData = decodeCache($cacheDataRaw);
	if(!is_array($cacheData)) return;
	
	return $cacheData;
}

function loadConfig($name="webengine") {
    global $config;
	if(!check_value($name)) return;
	if(!file_exists($config['path_config'] . $name . '.json')) return;
	$cfg = file_get_contents($config['path_config'] . $name . '.json');
	if(!check_value($cfg)) return;
	return json_decode($cfg, true);
}

function lang($phrase, $return=true) {
	global $lang;
	$result = $lang[$phrase];
	if(!$result) $result = 'ERROR';
	
		if($return) {
			return $result;
		} else {
			echo $result;
		}
}

function sec_to_hms($input_seconds=0) {
	$result = sec_to_dhms($input_seconds);
	if(!is_array($result)) return array(0,0,0);
	return array((($result[0]*24)+$result[1]), $result[2], $result[3]);
}

function sec_to_dhms($input_seconds=0) {
	if($input_seconds < 1) return array(0,0,0,0);
	$days_module = $input_seconds % 86400;
	$days = ($input_seconds-$days_module)/86400;
	$hours_module = $days_module % 3600;
	$hours = ($days_module-$hours_module)/3600;
	$minutes_module = $hours_module % 60;
	$minutes = ($hours_module-$minutes_module)/60;
	$seconds = $minutes_module;
	return array($days,$hours,$minutes,$seconds);
}

function siegeData() {
    if($this->_liveData == true) $this->_initDatabase();
    
    $result = array(
        'current_stage' => $this->getCurrentStage(),
        'next_stage' => $this->getNextStage(),
        'warfare_stage' => $this->getWarfareStage(),
        'castle_data' => $this->getCastleData(),
        'castle_owner_alliance' => $this->getCastleOwnerAlliance(),
        'registered_guilds' => $this->getRegisteredGuildsAndAlliances(),
        'schedule' => $this->getSchedule(),
        'next_stage_timeleft' => $this->_getSecondsForNextStage(),
        'next_stage_countdown' => $this->getNextStageCountdown(),
        'warfare_stage_timeleft' => $this->_getSecondsForWarfareStage(),
        'warfare_stage_countdown' => $this->getWarfareStageCountdown(),
        'warfare_duration' => $this->getWarfareDuration(),
    );
    
    return $result;
}

function langf($phrase, $args=array(), $print=false) {
	global $lang;
	$result = @vsprintf($lang, $args);
	if(!$result) $result = 'ERROR';
	
		if($print) {
			echo $result;
		} else {
			return $result;
		}
}

function returnGuildLogo($binaryData="", $size=40) {
	$imgSize = $size;
	return '<img src="webengine/guildmark.php?data='.$binaryData.'&size='.urlencode($size).'" width="'.$imgSize.'" height="'.$imgSize.'">';
}
