<?php
define('access', 'cron');
include("webengine/config.php");
include($config_launcher['path_root'] . "webengine.php");

$width = isset($_GET['width']) ? intval($_GET['width']) : 1038;
$height = isset($_GET['height']) ? intval($_GET['height']) : 570;

$WEB_BASE_URL = ($config_launcher['custom_url_enable'] == true ? $config_launcher['custom_url_link'] : __BASE_URL__);

$castleSiege = new CastleSiege();
if (!$castleSiege->showWidget()) return;
$siegeData = $castleSiege->siegeData();
if (!is_array($siegeData)) return;

if ($siegeData['castle_data']["CASTLE_OCCUPY"] == 1) {
    $guildOwner = $siegeData['castle_data']["OWNER_GUILD"];
    $guildOwnerMark = $siegeData['castle_owner_alliance'][0]["G_Mark"];
    $guildMaster = $siegeData['castle_owner_alliance'][0]["G_Master"];
} else {
    $guildOwner = '-';
    $guildOwnerMark = '1111111111111111111111111114411111144111111111111111111111111111';
    $guildMaster = '-';
}
$rk_castle_img_logo = ($config_launcher['custom_url_enable'] == true ? str_replace(__BASE_URL__, $config_launcher['custom_url_link'], returnGuildLogo($guildOwnerMark, 100)) : returnGuildLogo($guildOwnerMark, 100));

function DetectisBase64($string) {
    if (preg_match('/^[a-zA-Z0-9\/\r\n+]*={0,2}$/', $string) && strlen($string) % 4 === 0) {
        $decoded = base64_decode($string, true);
        if ($decoded !== false && base64_encode($decoded) === $string) {
            return $decoded;
        }
    }
    return false;
}

function recortarTexto($texto, $limite = 100) {
    if (mb_strlen($texto) > $limite) {
        return mb_substr($texto, 0, $limite) . '...';
    }
    return $texto;
}

// Verificar disponibilidad de datos
$topResets = LoadCacheData('rankings_resets.cache');
$topGuilds = LoadCacheData('rankings_guilds.cache');
$hasResets = is_array($topResets) && count($topResets) > 1;
$hasGuilds = is_array($topGuilds) && count($topGuilds) > 1;
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ZeroLauncher - Optimized Dashboard</title>
    <link href="webengine/css/style.css" rel="stylesheet" media="screen">
</head>

<body>
    <div class="main-container">
        <!-- Sección de Noticias -->
        <div class="news-section">
            <div class="section-header">
                <span>Last News</span>
                <a href="<?php echo $WEB_BASE_URL; ?>news" target="_blank">All news →</a>
            </div>
            <div class="news-list">
                <?php
                $cachedNews = loadCache('news.cache');
                if (is_array($cachedNews)) {
                    $i = 1;
                    foreach ($cachedNews as $newsArticle) {
                        if ($i <= $config_launcher['top_news']) {
                            $newsTitle = DetectisBase64($newsArticle['news_title']) ? base64_decode($newsArticle['news_title']) : $newsArticle['news_title'];
                            $newsTitle = recortarTexto($newsTitle,50);
                            echo '<div class="news-item">
                                    <a href="' . $WEB_BASE_URL . 'news/' . $newsArticle['news_id'] . '" target="_blank" class="news-title">
                                        ' . $newsTitle . '
                                    </a>
                                    <span class="news-date">' . date("M j, Y", $newsArticle['news_date']) . '</span>
                                  </div>';
                            $i++;
                        }
                    }
                } else {
                    echo '<div class="no-data">No news available</div>';
                }
                ?>
            </div>
        </div>

        <!-- Rankings Container con Layout Dinámico -->
        <div class="rankings-container <?php 
            if ($hasResets && $hasGuilds) {
                echo 'both-available';
            } elseif ($hasResets && !$hasGuilds) {
                echo 'only-resets';
            } elseif (!$hasResets && $hasGuilds) {
                echo 'only-guilds';
            } else {
                echo 'no-data';
            }
        ?>">
            
            <?php if ($hasResets): ?>
            <!-- Top Resets -->
            <div class="ranking-panel resets-panel">
                <div class="section-header">
                    <span><?php echo lang('rankings_txt_2'); ?></span>
                    <a href="<?php echo $WEB_BASE_URL; ?>rankings/resets" target="_blank">View →</a>
                </div>
                <div class="ranking-table">
                    <?php
                    $topLevelLimit = $config_launcher['top_resets'];
                    $showPlayerCountry = mconfig('show_country_flags') ? true : false;
                    $charactersCountry = loadCache('character_country.cache');
                    $topLevel = array_slice($topResets, 0, $topLevelLimit + 1);
                    
                    echo '<table class="table">
                            <thead>
                                <tr>
                                    <th>Character</th>
                                    <th>Class</th>
                                    <th>Resets</th>
                                </tr>
                            </thead>
                            <tbody>';
                    
                    foreach ($topLevel as $key => $row) {
                        if ($key == 0) continue;
                        $rk_reset_img_flag = ($config_launcher['custom_url_enable'] == true ? str_replace(__BASE_URL__, $config_launcher['custom_url_link'], getCountryFlag($charactersCountry[$row[0]])) : getCountryFlag($charactersCountry[$row[0]]));
                        $rk_reset_profile = ($config_launcher['custom_url_enable'] == true ? str_replace(__BASE_URL__, $config_launcher['custom_url_link'], playerProfile($row[0])) : playerProfile($row[0]));
                        
                        echo '<tr>
                                <td><img src="' . $rk_reset_img_flag . '" style="height:10px;" /> ' . $rk_reset_profile . '</td>
                                <td>' . $custom['character_class'][$row[1]][1] . '</td>
                                <td>' . number_format($row[2]) . '</td>
                              </tr>';
                    }
                    echo '</tbody></table>';
                    ?>
                </div>
            </div>
            <?php endif; ?>

            <?php if ($hasGuilds): ?>
            <!-- Top Guilds -->
            <div class="ranking-panel guilds-panel">
                <div class="section-header">
                    <span><?php echo lang('rankings_txt_4'); ?></span>
                    <a href="<?php echo $WEB_BASE_URL; ?>rankings/guilds" target="_blank">View →</a>
                </div>
                <div class="ranking-table">
                    <?php
                    $topLevelLimit = $config_launcher['top_guilds'];
                    $topLevel = array_slice($topGuilds, 0, $topLevelLimit + 1);
                    
                    echo '<table class="table">
                            <thead>
                                <tr>
                                    <th>Guild</th>
                                    <th>Score</th>
                                    <th>Logo</th>
                                </tr>
                            </thead>
                            <tbody>';
                    
                    foreach ($topLevel as $key => $row) {
                        if ($key == 0) continue;
                        $rk_guild_img_logo = ($config_launcher['custom_url_enable'] == true ? str_replace(__BASE_URL__, $config_launcher['custom_url_link'], returnGuildLogo($row[3], 12)) : returnGuildLogo($row[3], 12));
                        $rk_guild_profile = ($config_launcher['custom_url_enable'] == true ? str_replace(__BASE_URL__, $config_launcher['custom_url_link'], guildProfile($row[0])) : guildProfile($row[0]));
                        
                        echo '<tr>
                                <td>' . $rk_guild_profile . '</td>
                                <td>' . number_format($row[2]) . '</td>
                                <td>' . $rk_guild_img_logo . '</td>
                              </tr>';
                    }
                    echo '</tbody></table>';
                    ?>
                </div>
            </div>
            <?php endif; ?>

            <?php if (!$hasResets && !$hasGuilds): ?>
            <div class="no-data">No ranking data available</div>
            <?php endif; ?>
        </div>

        <!-- Castle Siege Banner -->
        <div class="castle-banner">
            <div class="castle-logo">
                <?php echo $rk_castle_img_logo; ?>
            </div>
            
            <div class="castle-info">
                <div class="castle-info-item">
                    <h4>Castle Owner</h4>
                    <div class="value"><?php echo $guildOwner; ?></div>
                </div>
                <div class="castle-info-item">
                    <h4>Guild Master</h4>
                    <div class="value"><?php echo $guildMaster; ?></div>
                </div>
            </div>
            
            <div class="castle-countdown">
                <h3>Siege Battle</h3>
                <div class="countdown-timer" id="cscountdown"><?php echo $siegeData['warfare_stage_countdown']; ?></div>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Efecto hover suave para tablas
            const tables = document.querySelectorAll('.table tbody tr');
            tables.forEach(row => {
                row.addEventListener('mouseenter', function() {
                    this.style.transform = 'translateX(2px)';
                    this.style.transition = 'transform 0.2s ease';
                });
                row.addEventListener('mouseleave', function() {
                    this.style.transform = 'translateX(0)';
                });
            });

            // Actualizar countdown cada segundo si es necesario
            const countdown = document.getElementById('cscountdown');
            if (countdown) {
                // Aquí puedes agregar lógica para countdown dinámico
            }
        });
    </script>
</body>
</html>