<?php
define('access', 'cron');
include("custom/config.php");
$config_json = json_decode(file_get_contents('../config.json'), true);

$width = isset($_GET['width']) ? intval($_GET['width']) : 1038;
$height = isset($_GET['height']) ? intval($_GET['height']) : 570;

try {
    if ($config_json['server']['sql_driver'] == 2) {
        $this->db = new PDO("odbc:Driver={SQL Server};Server=".$config_json['server']['sql_host'].";Database=".$config_json['server']['sql_db']."; Uid=".$config_json['server']['sql_user'].";Pwd=".$config_json['server']['sql_pass'].";");
    }else{
        if ($config_json['server']['sql_driver'] == 1) {
            $pdo_connect = "sqlsrv:Server=" . $config_json['server']['sql_host'] . "," . $config_json['server']['sql_port'] . ";Database=" . $config_json['server']['sql_db'] . "";
        } else {
            $pdo_connect = 'dblib:host=' . $config_json['server']['sql_host'] . ':' . $config_json['server']['sql_port'] . ';dbname=' . $config_json['server']['sql_db'];
        }

        $db = new PDO($pdo_connect, $config_json['server']['sql_user'], $config_json['server']['sql_pass']);
    }
    
} catch (PDOException $e) {
    echo "Error de conexion: " . $e->getMessage();
    die();
}

$stmt = $db->prepare('SELECT * FROM MuCastle_DATA');
$stmt->execute();
$siegeData = $stmt->fetchAll(PDO::FETCH_ASSOC);

$stmt = $db->prepare("SELECT G_Mark,G_Master FROM Guild WHERE G_Name='".$siegeData[0]['OWNER_GUILD']."'");
$stmt->execute();
$guild_info = $stmt->fetchAll(PDO::FETCH_ASSOC);

if(!isset($guild_info[0]) || $guild_info[0]["G_Master"]==''){
    $siegeData[0]["CASTLE_OCCUPY"]=0;
}

if ($siegeData[0]["CASTLE_OCCUPY"] == 1) {
    $guildOwner = $siegeData[0]["OWNER_GUILD"];
    $guildOwnerMark = $guild_info[0]["G_Mark"];
    $guildMaster = $guild_info[0]["G_Master"];
} else {
    $guildOwner = '-';
    $guildOwnerMark = '1111111111111111111111111114411111144111111111111111111111111111';
    $guildMaster = '-';
}


?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ZeroLauncher - Custom News</title>
    <link href="webengine/css/style.css" rel="stylesheet" media="screen">
</head>

<body>
    <div class="main-container">
        <!-- Sección de Noticias -->
        <div class="news-section">
            <div class="section-header">
                <span>Last News</span>
            </div>
            <div class="news-list">
                <?php
                $cachedNews = $config_json['client']['custom_news'];
                if (is_array($cachedNews)) {
                    $i = 1;
                    foreach ($cachedNews as $newsArticle) {
                        if ($i <= $config['top_news']) {
                            echo '<div class="news-item">
                                    <a href="' . $newsArticle['news_url'] . '" target="_blank" class="news-title">
                                        ' . $newsArticle['news_title'] . '
                                    </a>
                                    <span class="news-date">' . $newsArticle['news_date'] . '</span>
                                  </div>';
                            $i++;
                        }
                    }
                } else {
                    echo '<div class="no-data">No news available</div>';
                }
                ?>
            </div>
        </div>

        <!-- Rankings Container con Layout Dinámico -->
        <div class="rankings-container <?php 
            if ($config['enable_resets'] && $config['enable_guilds']) {
                echo 'both-available';
            } elseif ($config['enable_resets'] && !$config['enable_guilds']) {
                echo 'only-resets';
            } elseif (!$config['enable_resets'] && $config['enable_guilds']) {
                echo 'only-guilds';
            } else {
                echo 'no-data';
            }
        ?>">
            
            <?php if ($config['enable_resets']): ?>
            <!-- Top Resets -->
            <div class="ranking-panel resets-panel">
                <div class="section-header">
                    <span>Top Resets</span>
                </div>
                <div class="ranking-table">
                    <?php
                    $stmt = $db->prepare('SELECT TOP '.$config['top_resets'].' Name, cLevel, Class, ResetCount FROM Character ORDER BY ResetCount DESC');
                    $stmt->execute();
                    $topResets_query = $stmt->fetchAll(PDO::FETCH_ASSOC);
                    
                    echo '<table class="table">
                            <thead>
                                <tr>
                                    <th>Character</th>
                                    <th>Resets</th>
                                    <th>Level</th>
                                </tr>
                            </thead>
                            <tbody>';
                    
                    foreach ($topResets_query as $topResets) {
                        echo '<tr>
                                <td>' . $topResets['Name'] . '</td>
                                <td>' . $topResets['ResetCount'] . '</td>
                                <td>' . $topResets['cLevel'] . '</td>
                              </tr>';
                    }
                    echo '</tbody></table>';
                    ?>
                </div>
            </div>
            <?php endif; ?>

            <?php if ($config['enable_guilds']): ?>
            <!-- Top Guilds -->
            <div class="ranking-panel guilds-panel">
                <div class="section-header">
                    <span>Top Guilds</span>
                </div>
                <div class="ranking-table">
                    <?php
                    $stmt = $db->prepare('SELECT TOP '.$config['top_guilds'].' G_Name, G_Score, G_Mark FROM Guild ORDER BY G_Score DESC');
                    $stmt->execute();

                    $topGuilds_query = $stmt->fetchAll(PDO::FETCH_ASSOC);
                    
                    echo '<table class="table">
                            <thead>
                                <tr>
                                    <th>Guild</th>
                                    <th>Score</th>
                                    <th>Logo</th>
                                </tr>
                            </thead>
                            <tbody>';
                    
                    foreach ($topGuilds_query as $topGuilds) {
                        echo '<tr>
                                <td>' . $topGuilds['G_Name'] . '</td>
                                <td>' . $topGuilds['G_Score'] . '</td>
                                <td>' . returnGuildLogo($topGuilds['G_Mark'], 18) . '</td>
                              </tr>';
                    }
                    echo '</tbody></table>';
                    ?>
                </div>
            </div>
            <?php endif; ?>

            <?php if (!$config['enable_resets'] && !$config['enable_guilds']): ?>
            <div class="no-data">No ranking data available</div>
            <?php endif; ?>
        </div>

        <!-- Castle Siege Banner -->
         <?php if($config['enable_caslte']) { ?>
        <div class="castle-banner">
            <div class="castle-logo">
                <?php echo returnGuildLogo($guildOwnerMark, 100); ?>
            </div>
            
            <div class="castle-info">
                <div class="castle-info-item">
                    <h4>Castle Owner</h4>
                    <div class="value"><?php echo $guildOwner; ?></div>
                </div>
                <div class="castle-info-item">
                    <h4>Guild Master</h4>
                    <div class="value"><?php echo $guildMaster; ?></div>
                </div>
            </div>
            
            <div class="castle-countdown">
                <h3>Siege Battle</h3>
                <div class="countdown-timer" id="cscountdown"><?php echo TimeLeft($config['castle_siege_war_time']); ?></div>
            </div>
        </div>
        <?php } ?>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Efecto hover suave para tablas
            const tables = document.querySelectorAll('.table tbody tr');
            tables.forEach(row => {
                row.addEventListener('mouseenter', function() {
                    this.style.transform = 'translateX(2px)';
                    this.style.transition = 'transform 0.2s ease';
                });
                row.addEventListener('mouseleave', function() {
                    this.style.transform = 'translateX(0)';
                });
            });

            // Actualizar countdown cada segundo si es necesario
            const countdown = document.getElementById('cscountdown');
            if (countdown) {
                // Aquí puedes agregar lógica para countdown dinámico
            }
        });
    </script>
</body>
</html>