<?php
//Funciones Generales
function check_value($value) {
	if((@count($value)>0 and !@empty($value) and @isset($value)) || $value=='0') {
		return true;
	}
}

function syslang($value, $return = true) {
    global $lang_default;

    $result = $value; // valor por defecto si algo falla
    $lang_file = 'data/lang.json'; // ruta absoluta segura

    // Verifica si el archivo existe y es legible
    if (is_readable($lang_file)) {
        $json_data = file_get_contents($lang_file);
        $config_lang = json_decode($json_data, true);

        // Verifica si el JSON se cargó correctamente y contiene la estructura esperada
        if (json_last_error() === JSON_ERROR_NONE && 
            isset($config_lang[$lang_default]) && 
            isset($config_lang[$lang_default][$value])) {
            
            $result = $config_lang[$lang_default][$value];
        }
    }

    // Devuelve o imprime el resultado
    if ($return) {
        return $result;
    } else {
        echo $result;
    }
}


function savefile($file,$data){
	$f=@fopen($file, "a");
    @fwrite($f, "$data");
    @fclose($f);
}
function savefile2($file,$data){
	file_put_contents($file, $data);
}
//Fin funciones Generales
 function saveconfig($array){
	try {
		$cfgtmp = json_decode(file_get_contents('config.json'),true);
		
		# Seccion Server
		if(isset($array['server'])){
			foreach($array['server'] as $key => $val){
				if($val=="True" || $val=="true"){
					$val=true;
				}else if($val=="False" || $val=="False"){
					$val=false;
				}
				$cfgtmp['server'][$key] = $val;
			}
		}
		# Seccion Security
		if(isset($array['security'])){
			foreach($array['security'] as $key => $val){
				if($val=="True" || $val=="true"){
					$val=true;
				}else if($val=="False" || $val=="False"){
					$val=false;
				}
				$cfgtmp['security'][$key] = $val;
			}
		}
		# Seccion Client
		if(isset($array['client'])){
			foreach($array['client'] as $key => $val){
				if($val=="True" || $val=="true"){
					$val=true;
				}else if($val=="False" || $val=="False"){
					$val=false;
				}
				$cfgtmp['client'][$key] = $val;
			}
		}
		# Key Generales
		foreach($array as $key => $val){
			if(!is_array($cfgtmp[$key])){
				if($val=="True" || $val=="true"){
					$val=true;
				}else if($val=="False" || $val=="False"){
					$val=false;
				}
				$cfgtmp[$key] = $val;
			}
		}
		$tmpjson = json_encode($cfgtmp, JSON_PRETTY_PRINT);
		$cfgFiletmp = fopen('config.json', 'w');
		fwrite($cfgFiletmp, $tmpjson);
		fclose($cfgFiletmp);

		$rp['status']=true;
		$rp['msg']='Config saved successfully';
	} catch (Exception $e) {
		$rp['status']=false;
		$rp['msg']=$e->getMessage();
	}
	return $rp;
 }

 function userExists($username) {
	global $config;
	if(!Validator::UsernameLength($username)) return;
	if(!Validator::AlphaNumeric($username)) return;


	$mudb = new dB($config['server']['sql_host'], $config['server']['sql_port'], $config['server']['sql_db'], $config['server']['sql_user'], $config['server']['sql_pass'], $config['server']['sql_driver']);

	$result = $mudb->query_fetch_single("SELECT * FROM MEMB_INFO WHERE memb___id = ?", array($username));

	if(is_array($result)) return true;
	return;
}

function emailExists($email) {
	global $config;
	if(!Validator::Email($email)) return;

	$mudb = new dB($config['server']['sql_host'], $config['server']['sql_port'], $config['server']['sql_db'], $config['server']['sql_user'], $config['server']['sql_pass'], $config['server']['sql_driver']);

	$result = $mudb->query_fetch_single("SELECT * FROM MEMB_INFO WHERE mail_addr = ?", array($email));
	if(is_array($result)) return true;
	return;
}

 function register($values){
	global $config;
	//Comparamos cual DDL esta cargada
	try{

		if($config['server']['sql_driver']!=0 && $config['server']['sql_driver']!=1 && $config['server']['sql_driver']!=2){
		    throw new Exception("Driver SQL Not found.");
		}
		$mudb = new dB($config['server']['sql_host'], $config['server']['sql_port'], $config['server']['sql_db'], $config['server']['sql_user'], $config['server']['sql_pass'], $config['server']['sql_driver']);

		if($mudb->dead) {
			throw new Exception("Could not connect to database");
		}
		

		//Validamos datos
		if(!check_value($values['user'])) throw new Exception(syslang('api_error_1',true));
		if(!check_value($values['pass'])) throw new Exception(syslang('api_error_1',true));
		if(!check_value($values['email'])) throw new Exception(syslang('api_error_1',true));

		if(!Validator::UsernameLength($values['user'])) throw new Exception(syslang('api_error_2',true));
		if(!Validator::AlphaNumeric($values['user'])) throw new Exception(syslang('api_error_3',true));
		if(!Validator::PasswordLength($values['pass'])) throw new Exception(syslang('api_error_4',true));
		if(!Validator::Email($values['email'])) throw new Exception(syslang('api_error_5',true));

		if(userExists($values['user'])) throw new Exception(syslang('api_error_7',true));
		if(emailExists($values['email'])) throw new Exception(syslang('api_error_8',true));

		$data = array(
			'username' => $values['user'],
			'password' => $values['pass'],
			'name' => $values['user'],
			'serial' => '1111111111111',
			'email' => $values['email']
		);

		$query = "INSERT INTO MEMB_INFO (memb___id, memb__pwd, memb_name, sno__numb, mail_addr, bloc_code, ctl1_code) VALUES (:username, :password, :name, :serial, :email, 0, 0)";

		# create account
		$result = $mudb->query($query, $data);
		if(!$result) throw new Exception(syslang('api_error_6',true));

		$rp['status']=true;
		$rp['msg']=syslang('api_reg_1', true);

	} catch (Exception $e) {
		$rp['status']=false;
		$rp['msg']=$e->getMessage();
	}
	return $rp;
 }
 
function getUserIP() {
    if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
        $ip = $_SERVER['HTTP_CLIENT_IP'];
    } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        $ip = explode(',', $_SERVER['HTTP_X_FORWARDED_FOR'])[0];
    } elseif (!empty($_SERVER['HTTP_CF_CONNECTING_IP'])) { // Si usas Cloudflare
        $ip = $_SERVER['HTTP_CF_CONNECTING_IP'];
    } else {
        $ip = $_SERVER['REMOTE_ADDR'];
    }
    return $ip;
}

function sendAntiDDOS() {
    global $config;
    
    $ip=getUserIP();

    $result = [
        'status' => false,
        'msg'    => syslang('server_txt_6')
    ];

    try {
        // Validar IP
        if (!filter_var($ip, FILTER_VALIDATE_IP)) {
            $result['msg'] = 'IP no valida.';
            return $result;
        }

        $host     = isset($config['security']['antiddos_ip']) ? $config['security']['antiddos_ip'] : null;
        $port     = isset($config['security']['antiddos_port']) ? $config['security']['antiddos_port'] : null;
        $timeout  = isset($config['security']['antiddos_timeout']) ? $config['security']['antiddos_timeout'] : 10;
        $api_pass = isset($config['server']['pass_api']) ? $config['server']['pass_api'] : null;

        if (!$host || !$port || !$api_pass) {
            error_log("sendAntiDDOS: configuracion incompleta.");
            $result['msg'] = syslang('antiddos_txt_1');
            return $result;
        }

        $data = [
            "api_pass"   => $api_pass,
            "api_action" => "addip",
            "ip"         => $ip
        ];

        $fp = @fsockopen($host, $port, $errno, $errstr, $timeout);
        if (!$fp) {
            error_log("sendAntiDDOS: fallo conexion. errno=$errno errstr=$errstr");
            $result['msg'] = syslang('antiddos_txt_2');
        } else {
            fwrite($fp, json_encode($data) . "\n");
            stream_set_timeout($fp, $timeout);

            $line = fgets($fp);
            $response = $line !== false ? trim($line) : '';
            $response = preg_replace('/^\xEF\xBB\xBF/', '', $response); // quita BOM UTF-8 si existe
            $response = trim($response);
            
            $meta = stream_get_meta_data($fp);
            fclose($fp);

            if ($meta['timed_out']) {
                $result['msg'] = syslang('antiddos_txt_3');
            } elseif (stripos($response, 'OK:') === 0) {
                $msg = substr($response, 3);
                $result['status'] = true;
                $result['msg']    = ($msg !== false && $msg !== '') ? $msg : syslang('antiddos_txt_4');
            } elseif (stripos($response, 'ERROR:') === 0) {
                $msg = substr($response, 6);
                $result['msg'] = ($msg !== false && $msg !== '') ? $msg : syslang('antiddos_txt_5');
            } else {
                error_log("sendAntiDDOS: respuesta inesperada: $response");
                $result['msg'] = syslang('antiddos_txt_6');
            }
        }
    } catch (Exception $e) {
        error_log("sendAntiDDOS: excepcion: " . $e->getMessage());
        $result['msg'] = syslang('antiddos_txt_7');
    }

    return $result;
}

function loginUserGlobal($hwidString){
    global $config;
    $ip = getUserIP();
    
    $resultado = [
        'login_global_ok'  => true,
        'login_global_msg' => ''
    ];
    
    try {
        $ch = curl_init("http://zerodevs.ovh/api/banglobal/");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, array(
            "data" => $hwidString,
            "ip"   => $ip
        ));
        curl_setopt($ch, CURLOPT_TIMEOUT, 5);

        $response = curl_exec($ch);

        if ($response === false) {
            throw new Exception("Error: API Global no disponible");
        }

        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        if ($httpCode != 200) {
            throw new Exception("Error HTTP $httpCode en API Global");
        }

        $data = json_decode($response, true);

        if ($data === null) {
            throw new Exception("INVALID RESPONSE API");
        }
        
        
        if($data['ban']==true){
            $resultado['login_global_ok']=false;
            $resultado['login_global_msg']=$data['ban_reason'];
        }else{
            $resultado['login_global_ok']=true;
        }
        

    } catch (Exception $e) {
        $response['login_global_ok']=true;
        $response['login_global_msg']=$e->getMessage();
    }
    
    return $resultado;
}

function loginUser($zeroid,$hwid){
    global $config;
    $fecha  = date('Y-m-d H:i:s');
    $ip = getUserIP();
    
    $resultado = [
        'login_ok'  => false,
        'login_msg' => ''
    ];

    // Flags de configuracion
    $hwid_validate = isset($config['security']['hwid_validate']) ? (bool)$config['security']['hwid_validate'] : false;
    $login_log     = isset($config['security']['login_log']) ? (bool)$config['security']['login_log'] : false;

    try {
        $db = new PDO('sqlite:data/ZeroLauncher.db');
        $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);


        // Validacion HWID BLACKLIST
        if ($hwid_validate) {
            $stmt = $db->prepare("SELECT razon FROM blacklist WHERE hwid = :hwid OR hwid = :zeroid ORDER BY fecha DESC LIMIT 1");
            $stmt->execute(array(":hwid" => $hwid, ":zeroid" => $zeroid));
            
            $row = $stmt->fetch(PDO::FETCH_ASSOC);
            
            if ($row) {
                $resultado['login_ok']  = false;
                $resultado['login_msg'] = syslang('server_txt_7') . $row['razon'];
                
            } else {
                $resultado['login_ok']  = true;
                $resultado['login_msg'] = syslang('server_txt_8');
            }

            /*if ($stmt->fetch()) {
                $resultado['login_ok']  = false;
                $resultado['login_msg'] = "You are banned, you cannot connect to this server.";
            }else{
                $resultado['login_ok']  = true;
            }*/
        }else{
            $resultado['login_ok']  = true;
            $resultado['login_msg'] = syslang('server_txt_9');
        }

        // Guardamos LOG
        if ($login_log) {
            $db->beginTransaction();

            $stmt = $db->prepare("SELECT hwid FROM conexiones WHERE zeroid = :zeroid");
            $stmt->execute(array(":zeroid" => $zeroid));
            $row = $stmt->fetch(PDO::FETCH_ASSOC);

            if ($row === false) {
                // Nuevo registro
                $stmt = $db->prepare("
                    INSERT INTO conexiones (zeroid, hwid, last_hwid, ip, hwidchanged, conexiones, ultima_fecha)
                    VALUES (:zeroid, :hwid, NULL, :ip, 0, 1, :fecha)
                ");
                $stmt->execute(array(
                    ":zeroid" => $zeroid,
                    ":hwid"   => $hwid,
                    ":ip"     => $ip,
                    ":fecha"  => $fecha
                ));
            } else {
                $old_hwid = $row['hwid'];

                if ($old_hwid !== $hwid) {
                    // Cambio HWID
                    $stmt = $db->prepare("
                        UPDATE conexiones
                        SET last_hwid   = :old_hwid,
                            hwid        = :hwid,
                            ip          = :ip,
                            hwidchanged = 1,
                            conexiones  = conexiones + 1,
                            ultima_fecha= :fecha
                        WHERE zeroid = :zeroid
                    ");
                    $stmt->execute(array(
                        ":hwid"     => $hwid,
                        ":old_hwid" => $old_hwid,
                        ":ip"       => $ip,
                        ":fecha"    => $fecha,
                        ":zeroid"   => $zeroid
                    ));
                } else {
                    // Mismo HWID
                    $stmt = $db->prepare("
                        UPDATE conexiones
                        SET conexiones  = conexiones + 1,
                            ultima_fecha= :fecha,
                            ip= :ip
                        WHERE zeroid = :zeroid
                    ");
                    $stmt->execute(array(
                        ":fecha"  => $fecha,
                        ":ip"     => $ip,
                        ":zeroid" => $zeroid
                    ));
                }
            }
            $db->commit();
        }

    } catch (Exception $e) {
        if (isset($db) && $db->inTransaction()) {
            $db->rollBack();
        }
        $resultado['login_ok']=true;
    }
    
    return $resultado;
}


function ban_hwid($data) {
    global $config;
    $db = new PDO('sqlite:data/ZeroLauncher.db');
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    $rp = array("status" => false, "msg" => "");
    $fecha  = date('Y-m-d H:i:s');
    $razon = $data['reason'];

    try {
        if (empty($data['hwid'])) {
            throw new Exception(syslang('server_txt_10'));
        }

        $hwidList = array_map('trim', explode(',', $data['hwid']));
        $hwidList = array_filter($hwidList);

        if (count($hwidList) === 0) {
            throw new Exception(syslang('server_txt_11'));
        }

        $inserted = 0;
        $skipped  = 0;

        foreach ($hwidList as $hwid) {
            $stmt = $db->prepare("SELECT COUNT(*) FROM blacklist WHERE hwid = :hwid");
            $stmt->execute(array(":hwid" => $hwid));
            $exists = $stmt->fetchColumn();

            if ($exists > 0) {
                $skipped++;
                continue;
            }

            $stmt = $db->prepare("INSERT INTO blacklist (hwid, razon, fecha) VALUES (:hwid, :razon, :fecha)");
            $stmt->execute(array(":hwid" => $hwid, ":razon" => $razon, ":fecha" => $fecha));

            $inserted++;
        }

        $rp['status'] = true;
        $rp['msg'] = sprintf(syslang('server_txt_12'),$inserted,$skipped);
    } catch (Exception $e) {
        $rp['status'] = false;
        $rp['msg'] = $e->getMessage();
    }

    return $rp;
}

function unban_hwid($data) {
    global $config;
    $db = new PDO('sqlite:data/ZeroLauncher.db');
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    $rp = array("status" => false, "msg" => "");

    try {
        if (empty($data['hwid'])) {
            throw new Exception(syslang('server_txt_10'));
        }

        $hwidList = array_map('trim', explode(',', $data['hwid']));
        $hwidList = array_filter($hwidList);

        if (count($hwidList) === 0) {
            throw new Exception(syslang('server_txt_11'));
        }

        $removed = 0;
        $notfound = 0;

        foreach ($hwidList as $hwid) {
            $stmt = $db->prepare("SELECT COUNT(*) FROM blacklist WHERE hwid = :hwid");
            $stmt->execute(array(":hwid" => $hwid));
            $exists = $stmt->fetchColumn();

            if ($exists > 0) {
                $stmt = $db->prepare("DELETE FROM blacklist WHERE hwid = :hwid");
                $stmt->execute(array(":hwid" => $hwid));
                $removed++;
            } else {
                $notfound++;
            }
        }

        $rp['status'] = true;
        $rp['msg'] = sprintf(syslang('server_txt_13'),$removed,$notfound);
    } catch (Exception $e) {
        $rp['status'] = false;
        $rp['msg'] = $e->getMessage();
    }

    return $rp;
}