<?php
header('Content-Type: application/json; charset=utf-8');
include('classes/class.validator.php');
include('classes/class.database.php');
include('classes/engine.php');
$config = json_decode(file_get_contents('config.json'), true);
$lang_default = (!isset($_SERVER['HTTP_LANG']) ? $config['lang_default'] : $_SERVER['HTTP_LANG']);



$action=isset($_SERVER['HTTP_API_ACTION']) ? $_SERVER['HTTP_API_ACTION'] : null;
$pass = isset($_SERVER['HTTP_API_PASS']) ? $_SERVER['HTTP_API_PASS'] : null;
$values=isset($_SERVER['HTTP_VL_DATA']) ? json_decode(base64_decode($_SERVER['HTTP_VL_DATA']),true) : null;



function eliminarDirectorio($carpeta)
{
    if (is_dir($carpeta)) {
        $archivos = glob($carpeta . '/*');
        foreach ($archivos as $archivo) {
            is_dir($archivo) ? eliminarDirectorio($archivo) : unlink($archivo);
        }
        rmdir($carpeta);
    }
}

if ($pass == $config['server']['pass_api']) {
    switch ($action) {
        case 'getconfig':
            $rp = $config;
            $rp['status'] = true;
            $rp['msg'] = syslang('getconfig_ok', true);
            break;

        case 'saveconfig':
            $save = saveconfig($values);
            $rp['status'] = $save['status'];
            $rp['msg'] = $save['msg'];

            //$rp['cache'] = $values;
            $rp['cache'] = json_decode(file_get_contents('config.json'), true);
            $rp['cache']['status'] = true;
            break;
            
        case 'get_blacklist':
            try {
                $db = new PDO('sqlite:data/ZeroLauncher.db');
                $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

                $stmt = $db->query("SELECT * FROM blacklist ORDER BY fecha DESC");
                $blacklist = $stmt->fetchAll(PDO::FETCH_ASSOC);

                $rp['status'] = true;
                $rp['data']   = $blacklist;
            } catch (Exception $e) {
                $rp['status'] = false;
                $rp['msg']    = syslang('server_txt_1') . $e->getMessage();
            }
            break;

        case 'get_login_log':
            try {
                $db = new PDO('sqlite:data/ZeroLauncher.db');
                $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

                $stmt = $db->query("SELECT * FROM conexiones ORDER BY ultima_fecha DESC");
                $logs = $stmt->fetchAll(PDO::FETCH_ASSOC);

                $rp['status'] = true;
                $rp['data']   = $logs;
            } catch (Exception $e) {
                $rp['status'] = false;
                $rp['msg']    = syslang('server_txt_2') . $e->getMessage();
            }
            break;
            
        case 'ban_hwid':
            $response = ban_hwid($values);
            $rp['status']=$response['status'];
            $rp['msg']=$response['msg'];
            break;
            
        case 'unban_hwid':
            $response = unban_hwid($values);
            $rp['status']=$response['status'];
            $rp['msg']=$response['msg'];
            break;

        case 'up_patch':
            $uploads_dir = dirname(__FILE__) . "/patchs/";
            if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_FILES["file"])) {
                $archivo = $_FILES["file"];

                // Verifica si no hay errores durante la carga
                if ($archivo["error"] === UPLOAD_ERR_OK) {
                    $nombre_temporal = $archivo["tmp_name"];
                    $nombre_archivo = basename($archivo["name"]);

                    // Verifica que el archivo sea de tipo ZIP
                    $tipo_mime = mime_content_type($nombre_temporal);

                    if ($tipo_mime === "application/zip") {

                        $ruta_destino = $uploads_dir . $nombre_archivo;
                        move_uploaded_file($nombre_temporal, $ruta_destino);

                        $rp['status'] = true;
                        $rp['msg'] = syslang('upload_ok', true);
                    } else {
                        $rp['status'] = false;
                        $rp['msg'] = syslang('upload_error1', true);
                    }
                } else {
                    $rp['status'] = false;
                    $rp['msg'] = syslang('server_txt_3') . $archivo["error"];
                }
            }
            break;

        case 'up_crc_files':
            $uploads_dir = dirname(__FILE__) . "/crc/protect/";
            if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_FILES["file"])) {
                $archivo = $_FILES["file"];

                // Verifica si no hay errores durante la carga
                if ($archivo["error"] === UPLOAD_ERR_OK) {
                    $nombre_temporal = $archivo["tmp_name"];
                    $nombre_archivo = basename($archivo["name"]);

                    // Verifica que el archivo sea de tipo ZIP
                    $tipo_mime = mime_content_type($nombre_temporal);

                    if ($tipo_mime === "application/zip") {
                        $ruta_destino = $uploads_dir . $nombre_archivo;
                        move_uploaded_file($nombre_temporal, $ruta_destino);

                        $zip = new ZipArchive;
                        if ($zip->open($ruta_destino) === TRUE) {
                            // Crea un directorio para extraer el contenido
                            $extract_dir = $uploads_dir;

                            // Extrae el contenido del ZIP
                            $zip->extractTo($extract_dir);
                            $zip->close();

                            // Elimina el archivo ZIP
                            unlink($ruta_destino);

                            $rp['status'] = true;
                            $rp['msg'] = syslang('server_txt_4');
                        } else {
                            $rp['status'] = false;
                            $rp['msg'] = syslang('server_txt_5');
                        }

                    } else {
                        $rp['status'] = false;
                        $rp['msg'] = syslang('upload_error1', true);
                    }
                } else {
                    $rp['status'] = false;
                    $rp['msg'] = syslang('server_txt_3') . $archivo["error"];
                }
            }
            break;

        case 'up_crc':
            $uploads_dir = dirname(__FILE__) . "/crc/";
            $nombre_archivo = $_FILES['file']['name'];
            $nombre_archivo_temp = $_FILES["file"]["tmp_name"];
            

            if (!strpos($nombre_archivo, ".zr")) {
                $rp['status'] = false;
                $rp['msg'] = syslang('upload_error1', true);
            } else {
                if (move_uploaded_file($nombre_archivo_temp, $uploads_dir . $nombre_archivo)) {
                    $rp['status'] = true;
                    $rp['msg'] = syslang('upload_ok', true);
                } else {
                    $rp['status'] = false;
                    $rp['msg'] = syslang('upload_error', true);
                }
            }
            break;

        default:
            $rp['status'] = false;
            $rp['msg'] = syslang('error_action', true);
            break;
    }
} else {
    $rp['status'] = false;
    $rp['msg'] = syslang('error_api_pass', true);
}

echo json_encode($rp, JSON_PRETTY_PRINT);
