<?php
header('Content-Type: application/json; charset=utf-8');
include('classes/class.validator.php');
include('classes/class.database.php');
include('classes/engine.php');
$config=json_decode(file_get_contents('config.json'),true);

$lang_default=(!isset($_SERVER['HTTP_LANG']) ? $config['lang_default'] : $_SERVER['HTTP_LANG']);


$action=isset($_SERVER['HTTP_API_ACTION']) ? $_SERVER['HTTP_API_ACTION'] : null;
//$values=isset($_SERVER['HTTP_VL_DATA']) ? json_decode(base64_decode($_SERVER['HTTP_VL_DATA']),true) : null;
$values = null;
if (isset($_SERVER['HTTP_VL_DATA'])) {
    $values = json_decode(base64_decode($_SERVER['HTTP_VL_DATA']), true);
} else {
    // Si no está en header, lo buscamos en el body JSON
    $input = json_decode(file_get_contents("php://input"), true);
    if (isset($input['vl_data'])) {
        $values = json_decode(base64_decode($input['vl_data']), true);
    }
}



	switch ($action) {
		case 'getconfig':
			
			$rp['status']=true;
			$rp['lang_default']=$config['lang_default'];
			$rp['data']=$config['client'];
			//$rp['data']['lang']=@$lang['client'];
			if($config['client']['crc_enable']){
				$rp['crc']=json_decode(file_get_contents('crc/CRC.zr'),true);
			}
			
			//BAN GLOBAL
			if($config['security']['banglobal_enable']==true){
			    if($values != null){
			        if(isset($values['zeroid']) && isset($values['hwid'])){
			            $list_hwid=$values['zeroid'].','.$values['hwid'];
			            $check_banglobal=loginUserGlobal($list_hwid);
			            
			            if($check_banglobal['login_global_ok']==true){
			                $rp['login_global_ok']=true;
			            }else{
			                $razon=$check_banglobal['login_global_msg'];
			                $rp['login_global_ok']=false;
			                $rp['login_global_msg']=sprintf(syslang('banglobal_txt_1'),$razon);
			            }
			        }
			    }
			}else{
			    $rp['login_global_ok']=true;
			}
			
			//BAN LOCAL
			if($config['security']['hwid_validate']==true){
			    if(isset($rp['login_global_ok']) && $rp['login_global_ok']==false){
			        $rp['login_ok']=false;
			    }else if($values != null){
			        if(isset($values['zeroid']) && isset($values['hwid'])){
			            $check_user = loginUser($values['zeroid'],$values['hwid']);
			            if($check_user['login_ok']==true){
			                $rp['login_ok']=true;
			            }else{
			                $rp['login_ok']=false;
			                $rp['login_msg']=$check_user['login_msg'];
			            }
			        }
			    }
			}else{
			    $rp['login_ok']=true;
			}
			
			//ANTIDDOS
			if($config['security']['antiddos_enable']==true){
			    if(isset($rp['login_ok']) && $rp['login_ok']==false){
			        $rp['antiddos_ok']=false;
			        $rp['antiddos_msg']='';
			    }else{
			        $check_antiddos=sendAntiDDOS();
			        $rp['antiddos_ok']=$check_antiddos['status'];
			        $rp['antiddos_msg']=$check_antiddos['msg'];
			    }
			}else{
			    $rp['antiddos_ok']=true;
			}
			
			
			$rp['resources']=$config['resources'];
			break;

		case 'register':
			$send=register($values);
			$rp['status']=$send['status'];
			$rp['msg']=$send['msg'];
			break;
		
		case 'antiddos':
		    $ip=getUserIP();
		    $send=sendAntiDDOS($ip);
		    $rp['status']=$send['status'];
			$rp['msg']=$send['msg'];
			break;

		default:
			$rp['status']=false;
			$rp['msg']='Accion no encontrada';
			break;
	}

echo json_encode($rp, JSON_PRETTY_PRINT);

?>